
// Decimal.h
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef CRUFTY_DECIMAL_H
#define CRUFTY_DECIMAL_H

#include "Integer.h"

struct Decimal {
  // code-generator: cppgen --methodprototypes --no_tostring Decimal Integer
  Decimal();
  Decimal(const char *a);
  Decimal(const Integer &a);
  Decimal(int a);
  Decimal(long a);
  Decimal(unsigned long a);
  Decimal(long long a);
  Decimal(const Decimal &a);
  operator bool() const;
  operator int() const;
  operator short() const;
  operator long() const;
  operator long long() const;
  Decimal operator + () const;
  Decimal operator - () const;
  Decimal operator ~ () const;
  Decimal &operator = (const Decimal &a);
  Decimal &operator += (const Decimal &a);
  Decimal &operator -= (const Decimal &a);
  Decimal &operator *= (const Decimal &a);
  Decimal &operator /= (const Decimal &a);
  Decimal &operator %= (const Decimal &a);
  Decimal &operator ++ ();
  inline Decimal operator ++ (int) {
    Decimal result = *this;
    operator ++();
    return result;
  }
  Decimal &operator -- ();
  inline Decimal operator -- (int) {
    Decimal result = *this;
    operator --();
    return result;
  }
  // end code-generator

  std::string toString(int digitsBefore = 1, int digitsAfter = 0) const;
  void trim() const;

  Integer integer;
  int exp;
};

// code-generator: cppgen --functionprototypes Decimal Integer
std::ostream &operator << (std::ostream &os, const Decimal &x);
Decimal operator + (const Decimal &a, const Decimal &b);
Decimal operator + (const Decimal &a, const char *b);
Decimal operator + (const Decimal &a, int b);
Decimal operator + (const Decimal &a, long b);
Decimal operator + (const Decimal &a, long long b);
Decimal operator + (int a, const Decimal &b);
Decimal operator + (long a, const Decimal &b);
Decimal operator + (long long a, const Decimal &b);
Decimal operator + (const Decimal &a, const Integer &b);
Decimal operator + (const Integer &a, const Decimal &b);
Decimal operator - (const Decimal &a, const Decimal &b);
Decimal operator - (const Decimal &a, const char *b);
Decimal operator - (const Decimal &a, int b);
Decimal operator - (const Decimal &a, long b);
Decimal operator - (const Decimal &a, long long b);
Decimal operator - (int a, const Decimal &b);
Decimal operator - (long a, const Decimal &b);
Decimal operator - (long long a, const Decimal &b);
Decimal operator - (const Decimal &a, const Integer &b);
Decimal operator - (const Integer &a, const Decimal &b);
Decimal operator * (const Decimal &a, const Decimal &b);
Decimal operator * (const Decimal &a, const char *b);
Decimal operator * (const Decimal &a, int b);
Decimal operator * (const Decimal &a, long b);
Decimal operator * (const Decimal &a, unsigned long b);
Decimal operator * (const Decimal &a, long long b);
Decimal operator * (int a, const Decimal &b);
Decimal operator * (long a, const Decimal &b);
Decimal operator * (long long a, const Decimal &b);
Decimal operator * (const Decimal &a, const Integer &b);
Decimal operator * (const Integer &a, const Decimal &b);
Decimal operator / (const Decimal &a, const Decimal &b);
Decimal operator / (const Decimal &a, const char *b);
Decimal operator / (const Decimal &a, int b);
Decimal operator / (const Decimal &a, long b);
Decimal operator / (const Decimal &a, unsigned long b);
Decimal operator / (const Decimal &a, long long b);
Decimal operator / (int a, const Decimal &b);
Decimal operator / (long a, const Decimal &b);
Decimal operator / (long long a, const Decimal &b);
Decimal operator / (const Decimal &a, const Integer &b);
Decimal operator / (const Integer &a, const Decimal &b);
Decimal operator % (const Decimal &a, const Decimal &b);
Decimal operator % (const Decimal &a, const char *b);
Decimal operator % (const Decimal &a, int b);
Decimal operator % (const Decimal &a, long b);
Decimal operator % (const Decimal &a, long long b);
Decimal operator % (int a, const Decimal &b);
Decimal operator % (long a, const Decimal &b);
Decimal operator % (long long a, const Decimal &b);
Decimal operator % (const Decimal &a, const Integer &b);
Decimal operator % (const Integer &a, const Decimal &b);
Decimal operator << (const Decimal &a, const Decimal &b);
Decimal operator << (const Decimal &a, const char *b);
Decimal operator << (const Decimal &a, int b);
Decimal operator << (const Decimal &a, long b);
Decimal operator << (const Decimal &a, long long b);
Decimal operator << (int a, const Decimal &b);
Decimal operator << (long a, const Decimal &b);
Decimal operator << (long long a, const Decimal &b);
Decimal operator << (const Decimal &a, const Integer &b);
Decimal operator << (const Integer &a, const Decimal &b);
Decimal operator >> (const Decimal &a, const Decimal &b);
Decimal operator >> (const Decimal &a, const char *b);
Decimal operator >> (const Decimal &a, int b);
Decimal operator >> (const Decimal &a, long b);
Decimal operator >> (const Decimal &a, long long b);
Decimal operator >> (int a, const Decimal &b);
Decimal operator >> (long a, const Decimal &b);
Decimal operator >> (long long a, const Decimal &b);
Decimal operator >> (const Decimal &a, const Integer &b);
Decimal operator >> (const Integer &a, const Decimal &b);
Decimal operator & (const Decimal &a, const Decimal &b);
Decimal operator & (const Decimal &a, const char *b);
Decimal operator & (const Decimal &a, int b);
Decimal operator & (const Decimal &a, long b);
Decimal operator & (const Decimal &a, long long b);
Decimal operator & (int a, const Decimal &b);
Decimal operator & (long a, const Decimal &b);
Decimal operator & (long long a, const Decimal &b);
Decimal operator & (const Decimal &a, const Integer &b);
Decimal operator & (const Integer &a, const Decimal &b);
Decimal operator ^ (const Decimal &a, const Decimal &b);
Decimal operator ^ (const Decimal &a, const char *b);
Decimal operator ^ (const Decimal &a, int b);
Decimal operator ^ (const Decimal &a, long b);
Decimal operator ^ (const Decimal &a, long long b);
Decimal operator ^ (int a, const Decimal &b);
Decimal operator ^ (long a, const Decimal &b);
Decimal operator ^ (long long a, const Decimal &b);
Decimal operator ^ (const Decimal &a, const Integer &b);
Decimal operator ^ (const Integer &a, const Decimal &b);
Decimal operator | (const Decimal &a, const Decimal &b);
Decimal operator | (const Decimal &a, const char *b);
Decimal operator | (const Decimal &a, int b);
Decimal operator | (const Decimal &a, long b);
Decimal operator | (const Decimal &a, long long b);
Decimal operator | (int a, const Decimal &b);
Decimal operator | (long a, const Decimal &b);
Decimal operator | (long long a, const Decimal &b);
Decimal operator | (const Decimal &a, const Integer &b);
Decimal operator | (const Integer &a, const Decimal &b);
bool operator == (const Decimal &a, const Decimal &b);
bool operator == (const Decimal &a, const char *b);
bool operator == (const Decimal &a, int b);
bool operator == (const Decimal &a, long b);
bool operator == (const Decimal &a, long long b);
bool operator == (int a, const Decimal &b);
bool operator == (long a, const Decimal &b);
bool operator == (long long a, const Decimal &b);
bool operator == (const Decimal &a, const Integer &b);
bool operator == (const Integer &a, const Decimal &b);
bool operator < (const Decimal &a, const Decimal &b);
bool operator < (const Decimal &a, const char *b);
bool operator < (const Decimal &a, int b);
bool operator < (const Decimal &a, long b);
bool operator < (const Decimal &a, long long b);
bool operator < (int a, const Decimal &b);
bool operator < (long a, const Decimal &b);
bool operator < (long long a, const Decimal &b);
bool operator < (const Decimal &a, const Integer &b);
bool operator < (const Integer &a, const Decimal &b);
bool operator > (const Decimal &a, const Decimal &b);
bool operator > (const Decimal &a, const char *b);
bool operator > (const Decimal &a, int b);
bool operator > (const Decimal &a, long b);
bool operator > (const Decimal &a, long long b);
bool operator > (int a, const Decimal &b);
bool operator > (long a, const Decimal &b);
bool operator > (long long a, const Decimal &b);
bool operator > (const Decimal &a, const Integer &b);
bool operator > (const Integer &a, const Decimal &b);
bool operator != (const Decimal &a, const Decimal &b);
bool operator != (const Decimal &a, const char *b);
bool operator != (const Decimal &a, int b);
bool operator != (const Decimal &a, long b);
bool operator != (const Decimal &a, long long b);
bool operator != (int a, const Decimal &b);
bool operator != (long a, const Decimal &b);
bool operator != (long long a, const Decimal &b);
bool operator != (const Decimal &a, const Integer &b);
bool operator != (const Integer &a, const Decimal &b);
bool operator <= (const Decimal &a, const Decimal &b);
bool operator <= (const Decimal &a, const char *b);
bool operator <= (const Decimal &a, int b);
bool operator <= (const Decimal &a, long b);
bool operator <= (const Decimal &a, long long b);
bool operator <= (int a, const Decimal &b);
bool operator <= (long a, const Decimal &b);
bool operator <= (long long a, const Decimal &b);
bool operator <= (const Decimal &a, const Integer &b);
bool operator <= (const Integer &a, const Decimal &b);
bool operator >= (const Decimal &a, const Decimal &b);
bool operator >= (const Decimal &a, const char *b);
bool operator >= (const Decimal &a, int b);
bool operator >= (const Decimal &a, long b);
bool operator >= (const Decimal &a, long long b);
bool operator >= (int a, const Decimal &b);
bool operator >= (long a, const Decimal &b);
bool operator >= (long long a, const Decimal &b);
bool operator >= (const Decimal &a, const Integer &b);
bool operator >= (const Integer &a, const Decimal &b);
// end code-generator

#endif

