
// Integer.cpp
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include "precomp.h"
#include "Integer.h"
#include <iostream>
#include "logMsg.h"
#include "cross_platform.h"
#include "Decimal.h"

// code-generator: cppgen --functions --no_divide_by_int Integer
Integer operator + (const Integer &a, const Integer &b) {
  Integer result = a;
  result += b;
  return result;
}
Integer operator + (const Integer &a, int b) {
  return a + Integer(b);
}
Integer operator + (const Integer &a, const char *b) {
  return a + Integer(b);
}
Integer operator + (const Integer &a, long b) {
  return a + Integer(b);
}
Integer operator + (const Integer &a, long long b) {
  return a + Integer(b);
}
Integer operator + (int a, const Integer &b) {
  return Integer(a) + b;
}
Integer operator + (long a, const Integer &b) {
  return Integer(a) + b;
}
Integer operator + (long long a, const Integer &b) {
  return Integer(a) + b;
}
Integer operator - (const Integer &a, const Integer &b) {
  Integer result = a;
  result -= b;
  return result;
}
Integer operator - (const Integer &a, int b) {
  return a - Integer(b);
}
Integer operator - (const Integer &a, const char *b) {
  return a - Integer(b);
}
Integer operator - (const Integer &a, long b) {
  return a - Integer(b);
}
Integer operator - (const Integer &a, long long b) {
  return a - Integer(b);
}
Integer operator - (int a, const Integer &b) {
  return Integer(a) - b;
}
Integer operator - (long a, const Integer &b) {
  return Integer(a) - b;
}
Integer operator - (long long a, const Integer &b) {
  return Integer(a) - b;
}
Integer operator * (const Integer &a, const Integer &b) {
  Integer result = a;
  result *= b;
  return result;
}
Integer operator * (const Integer &a, int b) {
  return a * Integer(b);
}
Integer operator * (const Integer &a, const char *b) {
  return a * Integer(b);
}
Integer operator * (const Integer &a, long b) {
  return a * Integer(b);
}
Integer operator * (const Integer &a, long long b) {
  return a * Integer(b);
}
Integer operator * (int a, const Integer &b) {
  return Integer(a) * b;
}
Integer operator * (long a, const Integer &b) {
  return Integer(a) * b;
}
Integer operator * (long long a, const Integer &b) {
  return Integer(a) * b;
}
Integer operator / (const Integer &a, const Integer &b) {
  Integer result = a;
  result /= b;
  return result;
}
Integer operator / (const Integer &a, const char *b) {
  return a / Integer(b);
}
Integer operator / (const Integer &a, long b) {
  return a / Integer(b);
}
Integer operator / (const Integer &a, long long b) {
  return a / Integer(b);
}
Integer operator / (int a, const Integer &b) {
  return Integer(a) / b;
}
Integer operator / (long a, const Integer &b) {
  return Integer(a) / b;
}
Integer operator / (long long a, const Integer &b) {
  return Integer(a) / b;
}
bool operator == (const Integer &a, int b) {
  return a == Integer(b);
}
bool operator == (const Integer &a, const char *b) {
  return a == Integer(b);
}
bool operator == (const Integer &a, long b) {
  return a == Integer(b);
}
bool operator == (const Integer &a, long long b) {
  return a == Integer(b);
}
bool operator == (int a, const Integer &b) {
  return Integer(a) == b;
}
bool operator == (long a, const Integer &b) {
  return Integer(a) == b;
}
bool operator == (long long a, const Integer &b) {
  return Integer(a) == b;
}
bool operator < (const Integer &a, int b) {
  return a < Integer(b);
}
bool operator < (const Integer &a, const char *b) {
  return a < Integer(b);
}
bool operator < (const Integer &a, long b) {
  return a < Integer(b);
}
bool operator < (const Integer &a, long long b) {
  return a < Integer(b);
}
bool operator < (int a, const Integer &b) {
  return Integer(a) < b;
}
bool operator < (long a, const Integer &b) {
  return Integer(a) < b;
}
bool operator < (long long a, const Integer &b) {
  return Integer(a) < b;
}
bool operator > (const Integer &a, const Integer &b) {
  return b < a;
}
bool operator > (const Integer &a, int b) {
  return a > Integer(b);
}
bool operator > (const Integer &a, const char *b) {
  return a > Integer(b);
}
bool operator > (const Integer &a, long b) {
  return a > Integer(b);
}
bool operator > (const Integer &a, long long b) {
  return a > Integer(b);
}
bool operator > (int a, const Integer &b) {
  return Integer(a) > b;
}
bool operator > (long a, const Integer &b) {
  return Integer(a) > b;
}
bool operator > (long long a, const Integer &b) {
  return Integer(a) > b;
}
bool operator != (const Integer &a, const Integer &b) {
  return !(a == b);
}
bool operator != (const Integer &a, int b) {
  return a != Integer(b);
}
bool operator != (const Integer &a, const char *b) {
  return a != Integer(b);
}
bool operator != (const Integer &a, long b) {
  return a != Integer(b);
}
bool operator != (const Integer &a, long long b) {
  return a != Integer(b);
}
bool operator != (int a, const Integer &b) {
  return Integer(a) != b;
}
bool operator != (long a, const Integer &b) {
  return Integer(a) != b;
}
bool operator != (long long a, const Integer &b) {
  return Integer(a) != b;
}
bool operator <= (const Integer &a, const Integer &b) {
  return !(b < a);
}
bool operator <= (const Integer &a, int b) {
  return a <= Integer(b);
}
bool operator <= (const Integer &a, const char *b) {
  return a <= Integer(b);
}
bool operator <= (const Integer &a, long b) {
  return a <= Integer(b);
}
bool operator <= (const Integer &a, long long b) {
  return a <= Integer(b);
}
bool operator <= (int a, const Integer &b) {
  return Integer(a) <= b;
}
bool operator <= (long a, const Integer &b) {
  return Integer(a) <= b;
}
bool operator <= (long long a, const Integer &b) {
  return Integer(a) <= b;
}
bool operator >= (const Integer &a, const Integer &b) {
  return !(a < b);
}
bool operator >= (const Integer &a, int b) {
  return a >= Integer(b);
}
bool operator >= (const Integer &a, const char *b) {
  return a >= Integer(b);
}
bool operator >= (const Integer &a, long b) {
  return a >= Integer(b);
}
bool operator >= (const Integer &a, long long b) {
  return a >= Integer(b);
}
bool operator >= (int a, const Integer &b) {
  return Integer(a) >= b;
}
bool operator >= (long a, const Integer &b) {
  return Integer(a) >= b;
}
bool operator >= (long long a, const Integer &b) {
  return Integer(a) >= b;
}
Integer &Integer::operator ++ () {
  return *this += 1;
}
// end code-generator
Integer &Integer::operator -- () {
  return *this -= 1;
}
// end code-generator

Integer operator / (const Integer &a, int b) {
  Integer result;
  mpz_fdiv_q_ui(result.val, a.val, b);
  return result;
}

Integer::Integer(int a) {
  mpz_init_set_si(val, a);
}

Integer::Integer(long a) {
  mpz_init_set_si(val, a);
}

Integer::Integer(unsigned long a) {
  mpz_init_set_ui(val, a);
}

//----------------------------------------------------------------------
// These four functions are from:
// stackoverflow.com/questions/6248723/mpz-t-to-unsigned-long-long-conversion-gmp-lib
//----------------------------------------------------------------------

void mpz_set_sll(mpz_t n, long long sll) {
    mpz_set_si(n, (int)(sll >> 32));     /* n = (int)sll >> 32 */
    mpz_mul_2exp(n, n, 32 );             /* n <<= 32 */
    mpz_add_ui(n, n, (unsigned int)sll); /* n += (unsigned int)sll */
}

void mpz_set_ull(mpz_t n, unsigned long long ull) {
    mpz_set_ui(n, (unsigned int)(ull >> 32)); /* n = (unsigned int)(ull >> 32) */
    mpz_mul_2exp(n, n, 32);                   /* n <<= 32 */
    mpz_add_ui(n, n, (unsigned int)ull);      /* n += (unsigned int)ull */
}

unsigned long long mpz_get_ull(mpz_srcptr n) {
    unsigned int lo, hi;
    mpz_t tmp;

    mpz_init( tmp );
    mpz_mod_2exp( tmp, n, 64 );   /* tmp = (lower 64 bits of n) */

    lo = mpz_get_ui( tmp );       /* lo = tmp & 0xffffffff */
    mpz_div_2exp( tmp, tmp, 32 ); /* tmp >>= 32 */
    hi = mpz_get_ui( tmp );       /* hi = tmp & 0xffffffff */

    mpz_clear( tmp );

    return (((unsigned long long)hi) << 32) + lo;
}

long long mpz_get_sll(mpz_srcptr n) {
    return (long long)mpz_get_ull(n); /* just use unsigned version */
}

//----------------------------------------------------------------------
// And here is an addition of mine
//----------------------------------------------------------------------

void mpz_init_set_sll(mpz_t rop, long long op) {
  mpz_init(rop);
  mpz_set_sll(rop, op);
}

//----------------------------------------------------------------------

Integer::Integer(long long a) {
  if (sizeof(long) == sizeof(long long)) {
    // GMP doesn't do long longs. Often, they are identical to longs
    mpz_init_set_si(val, a);
  }
  else {
    //logMsg << "They're different" << std::endl;
    // Otherwise, Some tips on handling long longs:
    // https://stackoverflow.com/questions/6248723/mpz-t-to-unsigned-long-long-conversion-gmp-lib
    //lineabort();
    mpz_init_set_sll(val, a);
  }
}

Integer::operator long() const {
  return mpz_get_si(val);
}

Integer::operator double() const {
  return mpz_get_d(val);
}

Integer::operator long long() const {
  //logMsg << logValue(mpz_get_si(val)) << std::endl;
  //logMsg << logValue(sizeof(long)) << ' ' << logValue(sizeof(long long)) << std::endl;
  // as with the long long constructor
  if (sizeof(long) == sizeof(long long)) {
    // GMP doesn't do long longs. Often, they are identical to longs
    return mpz_get_si(val);
  }
  else {
    //logMsg << "They're different" << std::endl;
    // Otherwise, Some tips on handling long longs:
    // https://stackoverflow.com/questions/6248723/mpz-t-to-unsigned-long-long-conversion-gmp-lib
    //lineabort();
    //mpz_init_set_sll(val, a);
    //logMsg << logValue(mpz_get_sll(val)) << std::endl;
    return mpz_get_sll(val);
  }
  lineabort();
}

Integer::Integer() {
  mpz_init_set_si(val, 0);
}

Integer::Integer(const Integer &b) {
  mpz_init_set(val, b.val);
}

Integer::Integer(const char *s) {
  int result = mpz_init_set_str(val, s, 10);
  if (result) {
    logMsg << "Oops, " << logValue(s) << " is not a number." << std::endl;
  }
}

void Integer::scanString(const char *s) {
  /*int result =*/ gmp_sscanf(s, "%Zd", val);
  //logMsg << logValue(s) << ' ' << logValue(result) << ' ' << logValue(*this) << std::endl;
}

void Integer::assign(const char *s, int radix) {
  //lineabort();
  int result = mpz_set_str(val, s, radix);
  if (result) {
    logMsg << "Oops, " << logValue(s) << " is not a number." << std::endl;
  }
}

Integer::Integer(const Decimal &a) {
  mpz_init_set(val, a.integer.val);
  // TOODO: Make these power operations and test their performance
  for (int i = 0; i < a.exp; i++)
    mpz_mul_ui(val, val, 10);
  for (int i = 0; i > a.exp; i--)
    mpz_fdiv_q_ui(val, val, 10);
}

Integer::operator bool() const {
  return mpz_sgn(val);
}

Integer::operator int() const {
  return mpz_get_si(val);
}

Integer::operator short() const {
  return mpz_get_si(val);
}

bool operator == (const Integer &a, const Integer &b) {
  return !mpz_cmp(a.val, b.val);
}

bool operator < (const Integer &a, const Integer &b) {
  return mpz_cmp(a.val, b.val) < 0;
}

Integer &Integer::operator -= (const Integer &b) {
  mpz_sub(val, val, b.val);
  return *this;
}

Integer &Integer::operator = (const Integer &b) {
  mpz_set(val, b.val);
  return *this;
}

//Integer &Integer::operator >>= (const Integer &b) { // NEW!
Integer &Integer::operator >>= (long b) { // NEW!
  mpz_fdiv_q_2exp(val, val, b);
  return *this;
}

Integer &Integer::operator += (const Integer &b) {
  mpz_add(val, val, b.val);
  return *this;
}

Integer &Integer::operator %= (const Integer &b) {
  mpz_fdiv_r(val, val, b.val);
  return *this;
}

int operator % (const Integer &a, int b) {
  //logMsg << "Checkpoint " << logValue(b) << std::endl;
  //logMsg << "Checkpoint " << logValue(b) << std::endl;
  if (1 /*&& b >= 0*/) { // No measurable improvement
    //Integer result;
    //mpz_fdiv_r_ui(result.val, a.val, b);
    int result = mpz_fdiv_ui(a.val, b);
    //logMsg << logValue(result) << std::endl;
    return result;
  }
  else {
    return a % Integer(b);
  }
}

Integer operator & (const Integer &a, int b) {
  //logMsg << "Checkpoint" << std::endl;
  return a & Integer(b);
  //lineabort();
}

Integer operator % (const Integer &a, const Integer &b) {
  Integer result(a);
  result %= b;
  return result;
}

Integer &Integer::operator *= (const Integer &b) {
  mpz_mul(val, val, b.val);
  return *this;
}

Integer &Integer::operator /= (const Integer &b) {
  mpz_fdiv_q(val, val, b.val);
  return *this;
}

std::string Integer::toString() const {
  char *buf;
  //size_t size;
  buf = mpz_get_str(0, 10, val);
  std::string result = buf;
  free(buf);
  return result;
}

std::ostream &operator << (std::ostream &os, const Integer &b) {
  return os << b.val;
}

Integer::~Integer() {
  mpz_clear(val);
}

Integer Integer::operator - () const {
  Integer result;
  mpz_neg(result.val, val);
  return result;
}

Integer Integer::operator + () const {
  return *this;
}

Integer Integer::operator ~ () const {
  lineabort();
}

Integer operator >> (const Integer &a, const Integer &b) {
  lineabort();
}

Integer operator >> (const Integer &a, int b) {
  Integer result;
  mpz_fdiv_q_2exp(result.val, a.val, b);
  return result;
}

Integer operator >> (const Integer &a, long b) {
  Integer result;
  mpz_fdiv_q_2exp(result.val, a.val, b);
  return result;
}

Integer operator << (const Integer &a, int b) {
  Integer result;
  mpz_mul_2exp(result.val, a.val, b);
  return result;
}

Integer operator << (const Integer &a, long b) {
  Integer result;
  mpz_mul_2exp(result.val, a.val, b);
  return result;
}

Integer operator << (const Integer &a, const Integer &b) {
  lineabort();
}

Integer operator & (const Integer &a, const Integer &b) {
  Integer result;
  //lineabort();
  mpz_and(result.val, a.val, b.val);
  return result;
}

Integer operator | (const Integer &a, const Integer &b) {
  lineabort();
}

Integer operator ^ (const Integer &a, const Integer &b) {
  lineabort();
}

