
// Integer.h
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef INTEGER_H
#define INTEGER_H

#include <stdio.h>
#include <gmp.h>

struct Decimal;

struct Integer {
  // code-generator: cppgen --methodprototypes Integer
  Integer();
  Integer(const char *a);
  Integer(int a);
  Integer(long a);
  Integer(unsigned long a);
  Integer(long long a);
  Integer(const Integer &a);
  operator bool() const;
  operator int() const;
  operator short() const;
  operator long() const;
  operator long long() const;
  operator double() const;
  std::string toString() const;
  Integer operator + () const;
  Integer operator - () const;
  Integer operator ~ () const;
  Integer &operator = (const Integer &a);
  Integer &operator += (const Integer &a);
  Integer &operator -= (const Integer &a);
  Integer &operator *= (const Integer &a);
  Integer &operator /= (const Integer &a);
  Integer &operator %= (const Integer &a);
  Integer &operator >>= (long a);
  Integer &operator ++ ();
  inline Integer operator ++ (int) {
    Integer result = *this;
    operator ++();
    return result;
  }
  Integer &operator -- ();
  inline Integer operator -- (int) {
    Integer result = *this;
    operator --();
    return result;
  }
  // end code-generator
  void scanString(const char *s);
  ~Integer();
  Integer(const Decimal &a);
  void assign(const char *s, int radix);

  mpz_t val;
};

// code-generator: cppgen --functionprototypes Integer
std::ostream &operator << (std::ostream &os, const Integer &x);
Integer operator + (const Integer &a, const Integer &b);
Integer operator + (const Integer &a, const char *b);
Integer operator + (const Integer &a, int b);
Integer operator + (const Integer &a, long b);
Integer operator + (const Integer &a, long long b);
Integer operator + (int a, const Integer &b);
Integer operator + (long a, const Integer &b);
Integer operator + (long long a, const Integer &b);
Integer operator - (const Integer &a, const Integer &b);
Integer operator - (const Integer &a, const char *b);
Integer operator - (const Integer &a, int b);
Integer operator - (const Integer &a, long b);
Integer operator - (const Integer &a, long long b);
Integer operator - (int a, const Integer &b);
Integer operator - (long a, const Integer &b);
Integer operator - (long long a, const Integer &b);
Integer operator * (const Integer &a, const Integer &b);
Integer operator * (const Integer &a, const char *b);
Integer operator * (const Integer &a, int b);
Integer operator * (const Integer &a, long b);
Integer operator * (const Integer &a, long long b);
Integer operator * (int a, const Integer &b);
Integer operator * (long a, const Integer &b);
Integer operator * (long long a, const Integer &b);
Integer operator / (const Integer &a, const Integer &b);
Integer operator / (const Integer &a, const char *b);
Integer operator / (const Integer &a, int b);
Integer operator / (const Integer &a, long b);
Integer operator / (const Integer &a, long long b);
Integer operator / (int a, const Integer &b);
Integer operator / (long a, const Integer &b);
Integer operator / (long long a, const Integer &b);
Integer operator % (const Integer &a, const Integer &b);
Integer operator % (const Integer &a, const char *b);
int operator % (const Integer &a, int b);
Integer operator % (const Integer &a, long b);
Integer operator % (const Integer &a, long long b);
Integer operator % (int a, const Integer &b);
Integer operator % (long a, const Integer &b);
Integer operator % (long long a, const Integer &b);
Integer operator << (const Integer &a, const Integer &b);
Integer operator << (const Integer &a, const char *b);
Integer operator << (const Integer &a, int b);
Integer operator << (const Integer &a, long b);
Integer operator << (const Integer &a, long long b);
Integer operator << (int a, const Integer &b);
Integer operator << (long a, const Integer &b);
Integer operator << (long long a, const Integer &b);
Integer operator >> (const Integer &a, const Integer &b);
Integer operator >> (const Integer &a, const char *b);
Integer operator >> (const Integer &a, int b);
Integer operator >> (const Integer &a, long b);
Integer operator >> (const Integer &a, long long b);
Integer operator >> (int a, const Integer &b);
Integer operator >> (long a, const Integer &b);
Integer operator >> (long long a, const Integer &b);
Integer operator & (const Integer &a, const Integer &b);
Integer operator & (const Integer &a, const char *b);
Integer operator & (const Integer &a, int b);
Integer operator & (const Integer &a, long b);
Integer operator & (const Integer &a, long long b);
Integer operator & (int a, const Integer &b);
Integer operator & (long a, const Integer &b);
Integer operator & (long long a, const Integer &b);
Integer operator ^ (const Integer &a, const Integer &b);
Integer operator ^ (const Integer &a, const char *b);
Integer operator ^ (const Integer &a, int b);
Integer operator ^ (const Integer &a, long b);
Integer operator ^ (const Integer &a, long long b);
Integer operator ^ (int a, const Integer &b);
Integer operator ^ (long a, const Integer &b);
Integer operator ^ (long long a, const Integer &b);
Integer operator | (const Integer &a, const Integer &b);
Integer operator | (const Integer &a, const char *b);
Integer operator | (const Integer &a, int b);
Integer operator | (const Integer &a, long b);
Integer operator | (const Integer &a, long long b);
Integer operator | (int a, const Integer &b);
Integer operator | (long a, const Integer &b);
Integer operator | (long long a, const Integer &b);
bool operator == (const Integer &a, const Integer &b);
bool operator == (const Integer &a, const char *b);
bool operator == (const Integer &a, int b);
bool operator == (const Integer &a, long b);
bool operator == (const Integer &a, long long b);
bool operator == (int a, const Integer &b);
bool operator == (long a, const Integer &b);
bool operator == (long long a, const Integer &b);
bool operator < (const Integer &a, const Integer &b);
bool operator < (const Integer &a, const char *b);
bool operator < (const Integer &a, int b);
bool operator < (const Integer &a, long b);
bool operator < (const Integer &a, long long b);
bool operator < (int a, const Integer &b);
bool operator < (long a, const Integer &b);
bool operator < (long long a, const Integer &b);
bool operator > (const Integer &a, const Integer &b);
bool operator > (const Integer &a, const char *b);
bool operator > (const Integer &a, int b);
bool operator > (const Integer &a, long b);
bool operator > (const Integer &a, long long b);
bool operator > (int a, const Integer &b);
bool operator > (long a, const Integer &b);
bool operator > (long long a, const Integer &b);
bool operator != (const Integer &a, const Integer &b);
bool operator != (const Integer &a, const char *b);
bool operator != (const Integer &a, int b);
bool operator != (const Integer &a, long b);
bool operator != (const Integer &a, long long b);
bool operator != (int a, const Integer &b);
bool operator != (long a, const Integer &b);
bool operator != (long long a, const Integer &b);
bool operator <= (const Integer &a, const Integer &b);
bool operator <= (const Integer &a, const char *b);
bool operator <= (const Integer &a, int b);
bool operator <= (const Integer &a, long b);
bool operator <= (const Integer &a, long long b);
bool operator <= (int a, const Integer &b);
bool operator <= (long a, const Integer &b);
bool operator <= (long long a, const Integer &b);
bool operator >= (const Integer &a, const Integer &b);
bool operator >= (const Integer &a, const char *b);
bool operator >= (const Integer &a, int b);
bool operator >= (const Integer &a, long b);
bool operator >= (const Integer &a, long long b);
bool operator >= (int a, const Integer &b);
bool operator >= (long a, const Integer &b);
bool operator >= (long long a, const Integer &b);
// end code-generator

#endif

