
// stringify.cpp
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include "precomp.h"
#include "stringify.h"
#include <stdio.h>
#include "cross_platform.h"
//#include <iostream>
#include <string.h>

std::string stringify(short a) {
  //std::cerr << __LINE__ << ' ' << a << std::endl;;
  char s[7];
  sprintf(s, "%d", a);
  return s;
}

std::string stringify(int a) {
  char s[12];
  sprintf(s, "%d", a);
  //std::cerr << "yo " << __LINE__ << '[' << a << ',' << s << ']' << std::endl;;
  return s;
}

std::string stringify(unsigned long a) {
  //std::cerr << __LINE__ << ' ' << a << std::endl;;
  char s[12];
  sprintf(s, "%lu", a);
  return s;
}

std::string stringify(const std::string &a) {
  return a;
}

std::string stringify(long a) {
  //std::cerr << __LINE__ << ' ' << a << std::endl;;
  char s[12];
  sprintf(s, "%ld", a);
  return s;
}

std::string stringify(unsigned long long a) {
  char s[24];
  sprintf(s, "%lld", a);
  return s;
}

std::string stringify(long long a) {
  char s[24];
  sprintf(s, "%lld", a);
  //lineabort();
  return s;
}

  // check if there is a dot. If no, return the string
  // check if the string is shorter than the precision. If so, return it
  // check if the dot is further away than the precision. If so, remove it and all trailing digits
  // truncate at the precision

std::string stringifyPrec(double a, int precision) {
  char s[64];
  sprintf(s, "%1.*f", precision, a);
  //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
  char *dot = strchr(s, '.');
  if (!dot) {
    return s;
  }
  if (long(strlen(s)) < precision) {
    //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
    return s;
  }
  if (dot - s > precision) {
    *dot = 0;
    //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
    return s;
  }
  if (s[precision + 1] >= '5') {
    while (s[precision] == '9') {
      precision--;
    }
    if (s[precision] == '.') {
      s[precision] = 0;
      //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
      precision--;
      while (s[precision] == '9') {
        s[precision] = '0';
        precision--;
        if (precision < 0)
          return std::string("1") + s;
      }
      s[precision]++;
      //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
    }
    else {
      s[precision]++;
      s[precision + 1] = 0;
      //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
    }
  }
  else {
    while (s[precision] == '0') {
      precision--;
    }
    if (s[precision] == '.')
      precision--;
    s[precision + 1] = 0;
    //std::cerr << __LINE__ << ' ' << a << " <" << s << '>' << std::endl;;
  }
  return s;
}

std::string stringify(float a) {
  return stringifyPrec(a, 7);
}

// doubles are 8 bytes long with 52 significant non-sign bits = about 15.7 digits

std::string stringify(double a) {
  return stringifyPrec(a, 15);
}

std::string stringify(unsigned int a) {
  //std::cerr << __LINE__ << ' ' << a << std::endl;;
  char s[12];
  sprintf(s, "%d", a);
  return s;
}

std::string stringify(unsigned short a) {
  //std::cerr << __LINE__ << ' ' << a << std::endl;;
  char s[7];
  sprintf(s, "%d", a);
  return s;
}

std::string stringify(const tm &a) {
  char s[64];
  sprintf(s, "%04d/%02d/%02d %02d:%02d:%02d", 
    a.tm_year + 1900,
    a.tm_mon + 1,
    a.tm_mday,
    a.tm_hour,
    a.tm_min,
    a.tm_sec);
  return s;
}

String::String(const char *s): s(s) {
}

String::String(const std::string &s): s(s.c_str()) {
}

String::operator const char *() const {
  return s;
}

