
// DepTree.h (wizard code)
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef DEPTREE_H
#define DEPTREE_H

#include "ParseTree.h"
#include "quote.h"

// Extra includes and STYPE (user code)
#include <map>
#include "dep.h"
#include "stringify.h"
#define DEPSTYPE TreeNode *
#define DEPSTYPE_IS_TRIVIAL 0 // Can it be moved? Can bison resize the state stack?

struct SourceFile {
  YY_BUFFER_STATE bufferState;
  std::string filename;
  yyltype location;
  int inAMacro;
  std::string folder;
};

YY_BUFFER_STATE deplexGetCurrentBuffer();
FILE *deplexGetCurrentFile();

// (wizard code)
#define DEPLTYPE yyltype
#undef YYPRINT
#define YYPRINT(file, type, val) fprintf(file, "\"%s\"", quote(deptext).c_str())

struct DepTree;

extern DepTree *depTree;
extern yyltype deplloc;
extern int depdebug;
extern char *deptext;

int deplex();
int depparse();
YY_BUFFER_STATE dep_create_buffer(FILE *file, int size);
YY_BUFFER_STATE dep_scan_string(const char *str);
void dep_delete_buffer(YY_BUFFER_STATE ybs);
void dep_switch_to_buffer(YY_BUFFER_STATE ybs);
int depparseGetSymbolNumber(int token);
const char *depparseGetSymbolName(int symbol);

struct DepTree: ParseTree {
  int callParser(YY_BUFFER_STATE ybs);
  DepTree();
  int processToken(int argToken);
  int popBuffer();
  // Extra members (user code)
  void setVariable(const TreeNode *variable, const TreeNode *value, int env);
  int evaluateExpr(const TreeNode *node);
  void substituteCommand(const TreeNode *node);
  void callMacro(const TreeNode *node);
  void includeFile(const TreeNode *node, int nocd);
  void pushBuffer(const std::string &filename, int inAMacro);
  std::vector<SourceFile> sourceFileVector;
  void expandForLoop(const Position *pos, const std::string &identifier, const TreeNode *values,
    const TreeNode *ws, const TreeNode *cmd, std::ostringstream &os);
  void depTreeAddRule(const Position *pos);
  void depTreeAddCommand(std::string s/*, const Position *pos*/);
  void fastAddFile(const std::string &filename, const TreeNode *buildState,
    const TreeNode *buildOptionList, const TreeNode *folderIncludeList);
  int runImmediate(String cmd);
  int readFile(String filename);
  void addExistsExts(const TreeNode *node);
  void addOption(const std::string &s);

  int inAMacro;
  std::map<std::string, std::string> variableMap;
  int activeCode;
  std::string currentFolder;
  std::vector<int> ifstack;
  std::string depReaderCurrentFolder;
  Rule *rule;
  RuleSet *ruleset;
  short log_lexemes;
  short lookForDependencies;
  std::vector<std::string> libExt;
};

void removeComment(std::string &s);

#endif

