
// File.h
// Copyright 2015 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef FILE_H
#define FILE_H

#include <iostream>
#include <sstream>
#ifdef __GNUC__
#include <ext/stdio_filebuf.h>
#endif

/* Those headers are hard to read.
 * iosfwd has a forward declarations for basic_iostream etc
 * and typedefs for iostream etc.
 *
 * ios_base: ios_base (c++/ios, c++/bits/ios_base.h)
 * basic_ios<>: ios_base (c++/ios, c++/bits/basic_ios.h)
 * basic_ostream<>: virtual public basic_ios (c++/ostream)
 * basic_istream<>: virtual public basic_ios (c++/istream)
 * basic_iostream<>: basic_istream, basic_ostream (c++/istream in fact)
 *
 * ios
 * |
 * ios_base
 * |
 *
 */

struct File {
  File(const char *name); // this is a favour to a lot of testDiff calls
  File(const std::string &name);
  File(const std::string &name, long fd);
  File(const std::string &name, long fd, std::ostream &stream);
  File();
  std::iostream *getIOStream(std::ios::openmode flags
    = std::ios::in | std::ios::out | std::ios::trunc);
  std::ostream *getOStream(std::ios::openmode flags = std::ios::out | std::ios::trunc);
  std::istream *getIStream(std::ios::openmode flags = std::ios::in);
  int getFd(int oflag);
  int getTmpFd();
  ~File();
  void close();

  std::string filename;
  int dontDelete;

private:
  void *ptr;
  int pointsTo;
  int fd;
  __gnu_cxx::stdio_filebuf<char> *buf;
};

struct FileMap {
  FileMap(const char *name);
  ~FileMap();
  const char *mapFile(const char *name);

  const char *mapping;
  int mapSize;
};

template<class T> std::ostream &operator << (File &a, const T &b) {
  return *a.getOStream() << b;
}

int getHandleCount();

#endif

