
// LinuxMacroNames.cpp
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include "precomp.h"
#include "MacroNames.h"

const char *ErrnoToMacroName(int errorCode) {
  if (errorCode == 1)
    return "EPERM";
  if (errorCode == 2)
    return "ENOENT";
  if (errorCode == 3)
    return "ESRCH";
  if (errorCode == 4)
    return "EINTR";
  if (errorCode == 5)
    return "EIO";
  if (errorCode == 6)
    return "ENXIO";
  if (errorCode == 7)
    return "E2BIG";
  if (errorCode == 8)
    return "ENOEXEC";
  if (errorCode == 9)
    return "EBADF";
  if (errorCode == 10)
    return "ECHILD";
  if (errorCode == 11)
    return "EAGAIN";
  if (errorCode == 12)
    return "ENOMEM";
  if (errorCode == 13)
    return "EACCES";
  if (errorCode == 14)
    return "EFAULT";
  if (errorCode == 15)
    return "ENOTBLK";
  if (errorCode == 16)
    return "EBUSY";
  if (errorCode == 17)
    return "EEXIST";
  if (errorCode == 18)
    return "EXDEV";
  if (errorCode == 19)
    return "ENODEV";
  if (errorCode == 20)
    return "ENOTDIR";
  if (errorCode == 21)
    return "EISDIR";
  if (errorCode == 22)
    return "EINVAL";
  if (errorCode == 23)
    return "ENFILE";
  if (errorCode == 24)
    return "EMFILE";
  if (errorCode == 25)
    return "ENOTTY";
  if (errorCode == 26)
    return "ETXTBSY";
  if (errorCode == 27)
    return "EFBIG";
  if (errorCode == 28)
    return "ENOSPC";
  if (errorCode == 29)
    return "ESPIPE";
  if (errorCode == 30)
    return "EROFS";
  if (errorCode == 31)
    return "EMLINK";
  if (errorCode == 32)
    return "EPIPE";
  if (errorCode == 33)
    return "EDOM";
  if (errorCode == 34)
    return "ERANGE";
  if (errorCode == 35)
    return "EDEADLK";
  if (errorCode == 36)
    return "ENAMETOOLONG";
  if (errorCode == 37)
    return "ENOLCK";
  if (errorCode == 38)
    return "ENOSYS";
  if (errorCode == 39)
    return "ENOTEMPTY";
  if (errorCode == 40)
    return "ELOOP";
  if (errorCode == 42)
    return "ENOMSG";
  if (errorCode == 43)
    return "EIDRM";
  if (errorCode == 44)
    return "ECHRNG";
  if (errorCode == 45)
    return "EL2NSYNC";
  if (errorCode == 46)
    return "EL3HLT";
  if (errorCode == 47)
    return "EL3RST";
  if (errorCode == 48)
    return "ELNRNG";
  if (errorCode == 49)
    return "EUNATCH";
  if (errorCode == 50)
    return "ENOCSI";
  if (errorCode == 51)
    return "EL2HLT";
  if (errorCode == 52)
    return "EBADE";
  if (errorCode == 53)
    return "EBADR";
  if (errorCode == 54)
    return "EXFULL";
  if (errorCode == 55)
    return "ENOANO";
  if (errorCode == 56)
    return "EBADRQC";
  if (errorCode == 57)
    return "EBADSLT";
  if (errorCode == 59)
    return "EBFONT";
  if (errorCode == 60)
    return "ENOSTR";
  if (errorCode == 61)
    return "ENODATA";
  if (errorCode == 62)
    return "ETIME";
  if (errorCode == 63)
    return "ENOSR";
  if (errorCode == 64)
    return "ENONET";
  if (errorCode == 65)
    return "ENOPKG";
  if (errorCode == 66)
    return "EREMOTE";
  if (errorCode == 67)
    return "ENOLINK";
  if (errorCode == 68)
    return "EADV";
  if (errorCode == 69)
    return "ESRMNT";
  if (errorCode == 70)
    return "ECOMM";
  if (errorCode == 71)
    return "EPROTO";
  if (errorCode == 72)
    return "EMULTIHOP";
  if (errorCode == 73)
    return "EDOTDOT";
  if (errorCode == 74)
    return "EBADMSG";
  if (errorCode == 75)
    return "EOVERFLOW";
  if (errorCode == 76)
    return "ENOTUNIQ";
  if (errorCode == 77)
    return "EBADFD";
  if (errorCode == 78)
    return "EREMCHG";
  if (errorCode == 79)
    return "ELIBACC";
  if (errorCode == 80)
    return "ELIBBAD";
  if (errorCode == 81)
    return "ELIBSCN";
  if (errorCode == 82)
    return "ELIBMAX";
  if (errorCode == 83)
    return "ELIBEXEC";
  if (errorCode == 84)
    return "EILSEQ";
  if (errorCode == 85)
    return "ERESTART";
  if (errorCode == 86)
    return "ESTRPIPE";
  if (errorCode == 87)
    return "EUSERS";
  if (errorCode == 88)
    return "ENOTSOCK";
  if (errorCode == 89)
    return "EDESTADDRREQ";
  if (errorCode == 90)
    return "EMSGSIZE";
  if (errorCode == 91)
    return "EPROTOTYPE";
  if (errorCode == 92)
    return "ENOPROTOOPT";
  if (errorCode == 93)
    return "EPROTONOSUPPORT";
  if (errorCode == 94)
    return "ESOCKTNOSUPPORT";
  if (errorCode == 95)
    return "EOPNOTSUPP";
  if (errorCode == 96)
    return "EPFNOSUPPORT";
  if (errorCode == 97)
    return "EAFNOSUPPORT";
  if (errorCode == 98)
    return "EADDRINUSE";
  if (errorCode == 99)
    return "EADDRNOTAVAIL";
  if (errorCode == 100)
    return "ENETDOWN";
  if (errorCode == 101)
    return "ENETUNREACH";
  if (errorCode == 102)
    return "ENETRESET";
  if (errorCode == 103)
    return "ECONNABORTED";
  if (errorCode == 104)
    return "ECONNRESET";
  if (errorCode == 105)
    return "ENOBUFS";
  if (errorCode == 106)
    return "EISCONN";
  if (errorCode == 107)
    return "ENOTCONN";
  if (errorCode == 108)
    return "ESHUTDOWN";
  if (errorCode == 109)
    return "ETOOMANYREFS";
  if (errorCode == 110)
    return "ETIMEDOUT";
  if (errorCode == 111)
    return "ECONNREFUSED";
  if (errorCode == 112)
    return "EHOSTDOWN";
  if (errorCode == 113)
    return "EHOSTUNREACH";
  if (errorCode == 114)
    return "EALREADY";
  if (errorCode == 115)
    return "EINPROGRESS";
  if (errorCode == 116)
    return "ESTALE";
  if (errorCode == 117)
    return "EUCLEAN";
  if (errorCode == 118)
    return "ENOTNAM";
  if (errorCode == 119)
    return "ENAVAIL";
  if (errorCode == 120)
    return "EISNAM";
  if (errorCode == 121)
    return "EREMOTEIO";
  if (errorCode == 122)
    return "EDQUOT";
  if (errorCode == 123)
    return "ENOMEDIUM";
  if (errorCode == 124)
    return "EMEDIUMTYPE";
  if (errorCode == 125)
    return "ECANCELED";
  if (errorCode == 126)
    return "ENOKEY";
  if (errorCode == 127)
    return "EKEYEXPIRED";
  if (errorCode == 128)
    return "EKEYREVOKED";
  if (errorCode == 129)
    return "EKEYREJECTED";
  if (errorCode == 130)
    return "EOWNERDEAD";
  if (errorCode == 131)
    return "ENOTRECOVERABLE";
  if (errorCode == 132)
    return "ERFKILL";
  if (errorCode == 133)
    return "EHWPOISON";
  if (errorCode == 0)
    return "(Success)";
  return "(Unknown errno)";
}

const char *SignalToMacroName(unsigned int signal) {
  if (signal == 1)
    return "SIGHUP";
  if (signal == 2)
    return "SIGINT";
  if (signal == 3)
    return "SIGQUIT";
  if (signal == 4)
    return "SIGILL";
  if (signal == 5)
    return "SIGTRAP";
  if (signal == 6)
    return "SIGABRT";
  if (signal == 6)
    return "SIGIOT";
  if (signal == 7)
    return "SIGBUS";
  if (signal == 8)
    return "SIGFPE";
  if (signal == 9)
    return "SIGKILL";
  if (signal == 10)
    return "SIGUSR1";
  if (signal == 11)
    return "SIGSEGV";
  if (signal == 12)
    return "SIGUSR2";
  if (signal == 13)
    return "SIGPIPE";
  if (signal == 14)
    return "SIGALRM";
  if (signal == 15)
    return "SIGTERM";
  if (signal == 16)
    return "SIGSTKFLT";
  if (signal == 17)
    return "SIGCHLD";
  if (signal == 18)
    return "SIGCONT";
  if (signal == 19)
    return "SIGSTOP";
  if (signal == 20)
    return "SIGTSTP";
  if (signal == 21)
    return "SIGTTIN";
  if (signal == 22)
    return "SIGTTOU";
  if (signal == 23)
    return "SIGURG";
  if (signal == 24)
    return "SIGXCPU";
  if (signal == 25)
    return "SIGXFSZ";
  if (signal == 26)
    return "SIGVTALRM";
  if (signal == 27)
    return "SIGPROF";
  if (signal == 28)
    return "SIGWINCH";
  if (signal == 29)
    return "SIGIO";
  if (signal == 29)
    return "SIGLOST";
  if (signal == 30)
    return "SIGPWR";
  if (signal == 31)
    return "SIGSYS";
  if (signal == 31)
    return "SIGUNUSED";
  if (signal == 32)
    return "SIGRTMIN";
  if (signal == 8192)
    return "SIGSTKSZ";
  return "(Unknown signal)";
}

