
// MacroNames.h
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef MACRONAMES_H
#define MACRONAMES_H

#if defined _WIN32 || defined __CYGWIN__
#include <windows.h>
#endif

const char *ErrnoToMacroName(int errorCode);
const char *SignalToMacroName(unsigned e);

#if defined _WIN32 || defined __CYGWIN__
const char *WinErrorToMacroName(unsigned long errorCode);
const char *WindowMsgToMacroName(UINT message);
const char *NoteToMacroName(UINT message);
const char *CommonDlgErrorToMacroName(unsigned e);
const char *CbnToMacroName(UINT message);
const char *HResultToMacroName(HRESULT hr);
const char *HardwareExceptionToMacroName(unsigned e);
#endif

#if defined __CYGWIN__
#define _NDIS_ERROR_TYPEDEF_(a) a
#endif

#endif
