
// cross_platform.h
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef CROSS_PLATFORM_H
#define CROSS_PLATFORM_H

#include <sys/types.h>

/*

Check manifest defines with 'cpp -xc++ -dM /dev/null' or with ../ignite/identify.cpp

Good ones are: __CYGWIN__ _WIN32 __MVC_VER

*/

#define lineabort() lineabort_f(__FILE__, __LINE__, __FUNCTION__)
#define lineexit(exitcode) lineexit_f(__FILE__, __LINE__, __FUNCTION__, exitcode)

#ifndef __GNUC__
#define __attribute__(a)
#endif

void lineabort_f(const char *file, int line, const char *fn)
  __attribute__((noreturn));

void lineexit_f(const char *file, int line, const char *fn, int exitcode)
  __attribute__((noreturn));

#if defined _WIN32 && !defined __CYGWIN__

#if !defined __MINGW32__

#define strcasecmp stricmp

#endif

#if !defined __MINGW64__
typedef int pid_t; // not needed in mingw64
#endif

void sleep(int);

#define WEXITSTATUS(a) (a & 255)
#define WIFSIGNALED(a) 0
#define WTERMSIG(a) 0
#define WIFEXITED(a) 1

#define SIGALRM -97 //  it doesn't happen
#define SIGKILL -96 //  it doesn't happen

int kill(pid_t pid, int signal);
int unsetenv(const char *var);
int setenv(const char *var, const char *val, int overwrite);
int mkstemp(const char *filename);

#else

typedef char *LPSTR;
typedef const char *LPCSTR;

#if !defined _WIN32 && !defined __CYGWIN__

//typedef unsigned long DWORD; // this was for cygwin-32

typedef unsigned int DWORD; // this is for cygwin-64 and just about everything
typedef long LONG_PTR; // Not a pointer, thanks Microsoft!
typedef LONG_PTR LRESULT;

#define WINAPI

#endif

#define stricmp strcasecmp

#endif

#if defined(_WIN32) || defined(__CYGWIN__)

#define _NSIG 65 // Linux has 65 (my old guess was 123)

#else

#define __fastcall

typedef int HANDLE;
typedef int HINSTANCE;

typedef long HWND;

typedef struct {
} MSG;

int GetMessage(MSG *msg, HWND wnd, unsigned min, unsigned max);
int TranslateMessage(MSG *msg);
int DispatchMessage(MSG *msg);

#define FILE_READ_DATA 1
#define FILE_WRITE_DATA 2
#define FILE_SHARE_WRITE 2
#define CREATE_ALWAYS 2
#define OPEN_EXISTING 3

DWORD GetTickCount(void); // the void keyword is better for C
HANDLE CreateFile(LPCSTR, DWORD, DWORD, void *, DWORD, DWORD, HANDLE);
LPSTR GetCommandLine(void); // the void keyword is better for C
int WriteFile(HANDLE, const void *, DWORD, DWORD *, void *);
void Sleep(int millis);

#endif

#endif
