
/* Flex options (wizard code) */
%option prefix="dep"
%option nounput

%{

/* deplex.l (user code)
   Copyright 2022 Matthew Rickard
   This file is part of dep

   dep is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "DepTree.h"
#include "depparse.h"
/* Extra headers and functions (user code) */
#include "logMsg.h"

/* (wizard code) */

int depwrap() {
  /* (user code) */
  /* (wizard code) */
  return depTree->popBuffer();
}

%}

/* (user code) */

/*

Note: %in %out %outcmp %pseudo are not flex/bison keywords. Instead they are all scooped up
and reprocessed in CmdLine's much simpler predictive parser

*/

%%

include return depTree->processToken(KEYWORD_INCLUDE);
if return depTree->processToken(KEYWORD_IF);
includes return depTree->processToken(KEYWORD_INCLUDES);
syntax return depTree->processToken(KEYWORD_SYNTAX);
findincludes return depTree->processToken(KEYWORD_FINDINCLUDES);
-mixed return depTree->processToken(KEYWORD_MIXED);
else return depTree->processToken(KEYWORD_ELSE);
export return depTree->processToken(KEYWORD_EXPORT);
for return depTree->processToken(KEYWORD_FOR);
in return depTree->processToken(KEYWORD_IN);
cd return depTree->processToken(KEYWORD_CD);
%rescan return depTree->processToken(KEYWORD_RESCAN);
fileinfo return depTree->processToken(KEYWORD_FILEINFO);
failtime return depTree->processToken(KEYWORD_FAILTIME);
buildseconds return depTree->processToken(KEYWORD_BUILDSECONDS);
exists_file_ext return depTree->processToken(KEYWORD_EXISTS_FILE_EXT);
option return depTree->processToken(KEYWORD_OPTION);
folders return depTree->processToken(KEYWORD_FOLDERS);
buildstate return depTree->processToken(KEYWORD_BUILDSTATE);
changetime return depTree->processToken(KEYWORD_CHANGETIME);
filesize return depTree->processToken(KEYWORD_FILESIZE);
rebuiltsametime return depTree->processToken(KEYWORD_REBUILTSAMETIME);
then return depTree->processToken(KEYWORD_THEN);
end return depTree->processToken(KEYWORD_END);

OK return depTree->processToken(BUILDSTATE_VALUE);
STALE return depTree->processToken(BUILDSTATE_VALUE);
REBUILT return depTree->processToken(BUILDSTATE_VALUE);
REBUILT_SAME return depTree->processToken(BUILDSTATE_VALUE);
TOUCH return depTree->processToken(BUILDSTATE_VALUE);
STAT_DIFF return depTree->processToken(BUILDSTATE_VALUE);
SOURCES_STALE return depTree->processToken(BUILDSTATE_VALUE);
BUILDING return depTree->processToken(BUILDSTATE_VALUE);

\n return depTree->processToken(NEWLINE);

[ \t\r]+ return depTree->processToken(WS);

[%=$\{\}`!] return depTree->processToken(*yytext);

[a-zA-Z][a-zA-Z0-9_]* return depTree->processToken(IDENTIFIER);

\"[^\"]*\" return depTree->processToken(STRING);

'[^']*' return depTree->processToken(STRING);

\|\| return depTree->processToken(BARBAR);

[0-9/+\-:!.*()>@,;~@^&*+[\]<>,.?\\|]+ return depTree->processToken(EVERYTHINGELSE);
[0-9][0-9.e+-]+ return depTree->processToken(EVERYTHINGELSE);

\\\n return depTree->processToken(WS);

#.* return depTree->processToken(COMMENT);
#.*\\\n return depTree->processToken(COMMENT);

. return depTree->processToken(SCANNING_ERROR);

%%

/*----------------------------------------------------------------------
 * Epilogue (wizard code)
 *----------------------------------------------------------------------
 */

YY_BUFFER_STATE deplexGetCurrentBuffer() {
  return YY_CURRENT_BUFFER;
}

FILE *deplexGetCurrentFile() {
  return YY_CURRENT_BUFFER->yy_input_file;
}

/*----------------------------------------------------------------------
 * Epilogue (user code)
 *----------------------------------------------------------------------
 */
 
