
// (user code)

%define api.prefix {dep} // (customizable code api.prefix)
%locations // enable line+column tracking
%define parse.lac full // improve error messages by rewinding default reductions
%define parse.error verbose // add 'Unexpected X, expecting Y' to error messages
%define lr.default-reduction most // hold this at "most" (the lalr/ielr default) so the
                                  // lex/action order is constant

//%define lr.type canonical-lr // possibilites are: lalr (default), ielr, canonical-lr

%{

// depparse.y
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include "DepTree.h"
// Includes, defines and declarations (user code)
#include "dep.h"
#include <iostream>
#include "logMsg.h"

#define deperror(err) depTree->formatError(err, &deplloc, deptext, yystate) // (wizard code)

%}

// Unprecedenced terminal tokens (user code)

%token SCANNING_ERROR WS NEWLINE EVERYTHINGELSE IDENTIFIER COMMENT STRING

// Note: %in %out %outcmp %pseudo are not flex/bison keywords. Instead they are all scooped up
// and reprocessed in CmdLine's much simpler predictive parser

%token KEYWORD_INCLUDE KEYWORD_FOR KEYWORD_IN KEYWORD_CD KEYWORD_IF
%token KEYWORD_EXPORT KEYWORD_FILEINFO KEYWORD_BUILDSTATE
%token KEYWORD_SYNTAX KEYWORD_MIXED KEYWORD_FINDINCLUDES
%token KEYWORD_BUILDSECONDS KEYWORD_EXISTS_FILE_EXT KEYWORD_OPTION
%token KEYWORD_ELSE KEYWORD_INCLUDES KEYWORD_FAILTIME KEYWORD_FOLDERS
%token BUILDSTATE_VALUE KEYWORD_CHANGETIME KEYWORD_FILESIZE
%token KEYWORD_REBUILTSAMETIME KEYWORD_THEN KEYWORD_END KEYWORD_RESCAN

%nonassoc FORCE_SHIFT // Low precedence (user code)
%left BARBAR
%right '='
%nonassoc '!'
%nonassoc FORCE_REDUCE // High precedence (wizard code)

// Nonterminal types (user code)

// ---------------------------------------------------------------------
%% // Main grammar rule: file contents (user code)
// ---------------------------------------------------------------------

filecontents: newlinews stmtset {
  depTree->trunk = MAKENODE();
}

// ---------------------------------------------------------------------
// Zero or more statements
// ---------------------------------------------------------------------

stmtset: {
  MAKENODE();
}

stmtset: stmtset stmt {
  MAKENODE();
}

stmtset: stmtset inoroutstmt {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Expressions
// ---------------------------------------------------------------------

expr: expr '=' ws.opt expr {
  MAKENODE();
}

expr: '=' ws.opt expr {
  MAKENODE();
}

expr: expr BARBAR ws.opt expr {
  MAKENODE();
}

expr: argument ws.opt {
  MAKENODE();
}

expr: '!' ws.opt expr {
  MAKENODE();
}

expr: '!' ws.opt {
  MAKENODE();
}

// ---------------------------------------------------------------------
// ifexpr
// ---------------------------------------------------------------------

ifexpr: KEYWORD_IF ws.opt expr newline.opt {
  depTree->ifstack.push_back(depTree->activeCode);
  if (depTree->activeCode)
    depTree->activeCode = depTree->evaluateExpr($3);
  MAKENODE();
}

// ---------------------------------------------------------------------
// stmt
// ---------------------------------------------------------------------

stmt: KEYWORD_SYNTAX ws.opt argument WS argumentList newline {
  //logMsg << "Adding syntax for " << $3->str() << std::endl;
  std::string syntax = $5->str();
  removeComment(syntax);
  if (depTree->ruleset->syntaxMap.count($3->str()))
    delete depTree->ruleset->syntaxMap[$3->str()];
  depTree->ruleset->syntaxMap[$3->str()] = new Cmdspec(syntax.c_str(), 0, *$1->getPosition());
  MAKENODE();
}

stmt: KEYWORD_SYNTAX ws.opt argument newline {
  //logMsg << "Adding syntax for " << $3->str() << std::endl;
  if (depTree->ruleset->syntaxMap.count($3->str()))
    delete depTree->ruleset->syntaxMap[$3->str()];
  depTree->ruleset->syntaxMap[$3->str()] = new Cmdspec("", 0, *$1->getPosition());
  //logMsg << "Added syntax for " << $3->str() << std::endl;
  //if (depTree->ruleset->otherVerbosity >= 6) {
    //*depTree->ruleset->outputFile->getOStream() << "dep: adding syntax for " << $3->str() << std::endl;
  //}
  MAKENODE();
}

stmt: KEYWORD_SYNTAX ws.opt KEYWORD_MIXED ws.opt argument WS argumentList newline {
  //logMsg << "Adding syntax for " << $3->str() << std::endl;
  //Cmdspec *cmdspec = new Cmdspec($7->str().c_str(), CMDSPEC_KEEP_GOING, *$1->getPosition());
  std::string syntax = $7->str();
  removeComment(syntax);
  Cmdspec *cmdspec = new Cmdspec(syntax.c_str(), CMDSPEC_KEEP_GOING, *$1->getPosition());
  //cmdspec->flags |= CMDSPEC_KEEP_GOING;
  //logMsg << logValue($5->str()) << std::endl;
  if (depTree->ruleset->syntaxMap.count($5->str()))
    delete depTree->ruleset->syntaxMap[$5->str()];
  depTree->ruleset->syntaxMap[$5->str()] = cmdspec;
  //logMsg << "Added syntax for " << $3->str() << std::endl;
  //if (depTree->ruleset->otherVerbosity >= 6) {
    //*depTree->ruleset->outputFile->getOStream() << "dep: adding syntax for " << $5->str() << std::endl;
  //}
  MAKENODE();
}

stmt: KEYWORD_FINDINCLUDES ws.opt argument WS argumentList newline {
  //logMsg << "Adding findIncludes for " << $3->str() << ' ' << $5->str() << std::endl;
  depTree->ruleset->addIncludeSyntax($3->str() + $4->str() + $5->str());
  MAKENODE();
}

fileInfoOptionList: {
  MAKENODE();
}

fileInfoOptionList: fileInfoOptionList fileInfoOption newline {
  MAKENODE();
}

/*failtime.opt: {
  MAKENODE();
}*/

fileInfoOption: KEYWORD_FAILTIME ws.opt timestamp {
  MAKENODE();
}

fileInfoOption: KEYWORD_BUILDSECONDS ws.opt EVERYTHINGELSE ws.opt {
  MAKENODE();
}

fileInfoOption: KEYWORD_FILESIZE ws.opt EVERYTHINGELSE ws.opt {
  MAKENODE();
}

fileInfoOption: KEYWORD_CHANGETIME ws.opt timestamp {
  MAKENODE();
}

fileInfoOption: KEYWORD_REBUILTSAMETIME ws.opt timestamp {
  //logMsg << "Found a rebuiltsametime" << std::endl;
  MAKENODE();
}

fileInfoOption: KEYWORD_CHANGETIME ws.opt IDENTIFIER ws.opt {
  MAKENODE();
}

stmt: KEYWORD_FILEINFO ws.opt argument ws.opt newline
    KEYWORD_BUILDSTATE ws.opt BUILDSTATE_VALUE ws.opt newline
    fileInfoOptionList
    includes {
  if (depTree->activeCode) {
    std::string dequoted;
    skipAndDequote($3->str().c_str(), &dequoted);
    depTree->fastAddFile(dequoted, $8, $11, $12); // NOTE! Add filesize DONE
  }
  MAKENODE();
};

// XXX Don't require the braces. This one requires braces.
// Maybe drop the newline.opt
// TODO: These are identical in the first body. Combine

stmt: percent ws.opt argument ws argumentList
{
  if (depTree->activeCode) {
    std::string cmd = $1->str() + $2->str() + $3->str(HIDDEN_QUOTE) + $4->str() + $5->str(HIDDEN_QUOTE);
    for (;;) {
      size_t hash = cmd.find("#");
      if (hash == std::string::npos)
        break;
      size_t newline = cmd.find('\n', hash);
      //logMsg << "Looks like there is a comment in there at " << hash << ' ' << logValue(newline) << std::endl;
      //logMsg << cmd << std::endl;
      cmd.erase(hash - 1, newline - hash + 3);
      //logMsg << cmd << std::endl;
    }
    if (!depTree->runImmediate(cmd)) {
      depTree->depTreeAddRule($1->getPosition());
      depTree->lookForDependencies = 1;
      depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
      depTree->lookForDependencies = 0;
    }
  }
} '{' newlinews internalstmtset '}' newlinews {
  MAKENODE();
}

// Here is one without braces

stmt: percent ws.opt argument ws argumentList
{
  if (depTree->activeCode) {
    std::string cmd = $1->str() + $2->str() + $3->str(HIDDEN_QUOTE) + $4->str() + $5->str(HIDDEN_QUOTE);
    for (;;) {
      size_t hash = cmd.find("#");
      if (hash == std::string::npos)
        break;
      size_t newline = cmd.find('\n', hash);
      //logMsg << "Looks like there is a comment in there at " << hash << ' ' << logValue(newline) << std::endl;
      //logMsg << cmd << std::endl;
      cmd.erase(hash - 1, newline - hash + 3);
      //logMsg << cmd << std::endl;
    }
    if (!depTree->runImmediate(cmd)) {
      depTree->depTreeAddRule($1->getPosition());
      depTree->lookForDependencies = 1;
      depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
      depTree->lookForDependencies = 0;
    }
  }
} newline {
  MAKENODE();
}

// Note:
// * Internal stmts have only a subset of the available stmt structures, and do not nest

stmt: '{' {
  //logMsg << "calling depTreeAddRule" << std::endl;
  depTree->depTreeAddRule($1->getPosition());
  depTree->lookForDependencies = 1;

} newlinews internalstmtset '}' newlinews {
  MAKENODE();
}

stmt: KEYWORD_FOR ws.opt IDENTIFIER ws.opt KEYWORD_IN ws.opt argumentList newline.opt {
  depTree->ifstack.push_back(depTree->activeCode);
  depTree->activeCode = 0;
}
'{' newlinews stmtset '}' {
  depTree->activeCode = depTree->ifstack.back();
  depTree->ifstack.pop_back();
  if (depTree->activeCode) {
    std::ostringstream oss;
    //logMsg << "stmtSet is " << quote($11->str()) << std::endl;
    //logMsg << "Expanding " << $7->str() << " into " << quote($10->str()) << quote($11->str())
      //<< std::endl;
    depTree->expandForLoop($1->getPosition(), $3->str(), $7, $11, $12, oss);
    depTree->pushBuffer(depTree->filename /*+ " loop expansion"*/, 1);
    //logMsg << "Replacement is " << quote(oss.str()) << std::endl;
    dep_scan_string(oss.str().c_str());
  }
  //logMsg << $$->str() << std::endl;
}
newline.opt {
  MAKENODE();
}

stmt: stmtArgument newline {
  //if (depTree->ruleset->otherVexrbosity >= 1) {
    //*depTree->ruleset->outputFile->getOStream() << currentLine << ' ' << logValue(depTree->activeCode) << std::endl;
  //}
  if (depTree->activeCode) {
    std::string cmd = $1->str();
    if (!depTree->runImmediate(cmd)) {
      std::string savedFolder = depTree->depReaderCurrentFolder;
      depTree->depReaderCurrentFolder = depTree->currentFolder;
      depTree->depTreeAddRule($1->getPosition());
      depTree->lookForDependencies = 1;
      depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
      depTree->depReaderCurrentFolder = savedFolder;
    }
  }
  //else
    //logMsg << "Not adding line " << $1->str() << std::endl;
  MAKENODE();
}

stmt: stmtArgument ws argumentList newline {
  //if (depTree->ruleset->otherVexrbosity >= 1) {
    //*depTree->ruleset->outputFile->getOStream() << currentLine << ' ' << logValue(depTree->activeCode) << std::endl;
  //}
  //logMsg << *$1->getPosition() << ' ' << logValue(depTree->activeCode) << std::endl;
  if (depTree->activeCode) {
    std::string cmd = $1->str(HIDDEN_QUOTE) + $2->str() + $3->str();
    if (!depTree->runImmediate(cmd)) {
      std::string savedFolder = depTree->depReaderCurrentFolder;
      depTree->depReaderCurrentFolder = depTree->currentFolder;
      depTree->depTreeAddRule($1->getPosition());
      depTree->lookForDependencies = 1;
      // Using the position of the newline. Other things might be macros
      //Position p = *($4->getPosition());
      depTree->depTreeAddCommand(cmd/*, &p*/);
      depTree->depReaderCurrentFolder = savedFolder;
    }
  }
  //else
    //logMsg << "Not adding line" << std::endl;
  MAKENODE();
}

stmt: KEYWORD_INCLUDE ws.opt argument {
  depTree->includeFile($3, 0);
}
newline {
  MAKENODE();
}

stmt: KEYWORD_INCLUDE ws.opt argument ws {
  depTree->includeFile($3, 0);
}
newline {
  MAKENODE();
}

stmt: KEYWORD_INCLUDE ws.opt argument ws argument {
  depTree->includeFile($5, 1);
}
newline {
  MAKENODE();
}

stmt: KEYWORD_EXISTS_FILE_EXT ws.opt argumentList {
  depTree->addExistsExts($3);
}
newline {
  MAKENODE();
}

stmt: KEYWORD_OPTION ws.opt argumentList {
  //logMsg << *$3->getPosition() << std::endl;
  depTree->addOption($3->str());
}
newline {
  MAKENODE();
}

// ---------------------------------------------------------------------
// internalstmt
// ---------------------------------------------------------------------

internalstmt: KEYWORD_CD ws.opt argument newline {
  if (depTree->rule) {
    depTree->rule->ruleFolder = $3->str();
  }
  MAKENODE();
}

internalstmt: KEYWORD_RESCAN ws.opt newline {
  depTree->lookForDependencies = 1;
  MAKENODE();
}

// This flicks yy_state_t from yytype_uint8 to yytype_uint16
// Because it bumps YYNSTATES from 255 to 259

internalstmt: stmtArgument newline {
  if (depTree->activeCode) {
    std::string cmd = $1->str();
    if (!depTree->runImmediate(cmd)) {
      std::string savedFolder = depTree->depReaderCurrentFolder;
      depTree->depReaderCurrentFolder = depTree->currentFolder;
      depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
      depTree->depReaderCurrentFolder = savedFolder;
    }
  }
  //else
    //logMsg << "Not adding line" << std::endl;
  MAKENODE();
}

stmt: KEYWORD_EXPORT ws.opt IDENTIFIER '=' ws.opt argumentList newline {
  //logMsg << "exporting " << $3->str() << '=' << $6->str() << " during parse" << std::endl;
  depTree->setVariable($3, $6, 1);
  MAKENODE();
}

internalstmt: KEYWORD_EXPORT ws.opt IDENTIFIER '=' ws.opt argumentList newline {
  int newWay = 1;
  if (newWay) {
    if (depTree->activeCode) {
      std::string cmd = $1->str(HIDDEN_QUOTE) + $2->str()
        + $3->str() + $4->str() + $5->str() + $6->str();
      std::string savedFolder = depTree->depReaderCurrentFolder;
      depTree->depReaderCurrentFolder = depTree->currentFolder;

      if (!depTree->rule)
        lineabort();
      depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
      depTree->depReaderCurrentFolder = savedFolder;
    }
  }
  depTree->setVariable($3, $6, 0); // just set it for now don't export it yet
  MAKENODE();
}

internalstmt: stmtArgument ws argumentList newline {
  if (depTree->activeCode) {
    std::string cmd = $1->str(HIDDEN_QUOTE) + $2->str() + $3->str();
    std::string savedFolder = depTree->depReaderCurrentFolder;
    depTree->depReaderCurrentFolder = depTree->currentFolder;

    if (!depTree->rule)
      lineabort();
    depTree->depTreeAddCommand(cmd/*, $1->getPosition()*/);
    depTree->depReaderCurrentFolder = savedFolder;
  }
  MAKENODE();
}

internalstmtset: {
  MAKENODE();
}

internalstmtset: internalstmtset internalstmt {
  MAKENODE();
}

internalstmtset: internalstmtset inoroutstmt {
  MAKENODE();
}

internalstmt: ifexpr KEYWORD_THEN ws.opt newline internalstmtset {
  if (depTree->ifstack.size()) {
    depTree->activeCode = depTree->ifstack.back();
    depTree->ifstack.pop_back();
  }
}
KEYWORD_END newline {
  MAKENODE();
}

internalstmt: ifexpr KEYWORD_THEN ws.opt newline internalstmtset {
  if (depTree->ifstack.back())
    depTree->activeCode = !depTree->activeCode;
}
KEYWORD_ELSE ws.opt newline internalstmtset {
  if (depTree->ifstack.size()) {
    depTree->activeCode = depTree->ifstack.back();
    depTree->ifstack.pop_back();
  }
}
KEYWORD_END newline {
  MAKENODE();
}

stmt: ifexpr KEYWORD_THEN ws.opt newline stmtset {
  if (depTree->ifstack.size()) {
    depTree->activeCode = depTree->ifstack.back();
    depTree->ifstack.pop_back();
  }
}
KEYWORD_END newline {
  MAKENODE();
}

stmt: ifexpr KEYWORD_THEN ws.opt newline stmtset {
  if (depTree->ifstack.back())
    depTree->activeCode = !depTree->activeCode;
}
KEYWORD_ELSE ws.opt newline stmtset {
  if (depTree->ifstack.size()) {
    depTree->activeCode = depTree->ifstack.back();
    depTree->ifstack.pop_back();
  }
}
KEYWORD_END newline {
  MAKENODE();
}

// ---------------------------------------------------------------------
// inoroutstmt
// ---------------------------------------------------------------------

inoroutstmt: argument '=' ws.opt argumentList {
  //*depTree->ruleset->outputFile->getOStream() << "Setting variable "
    //<< $1->str() << " to " << $4->str() << std::endl;
  depTree->setVariable($1, $4, 0);
}
newline {
  MAKENODE();
}

// ---------------------------------------------------------------------
// stmtArgument
// ---------------------------------------------------------------------

stmtArgument: argument {
  depTree->currentFolder = depTree->depReaderCurrentFolder;
  MAKENODE();
}

// ---------------------------------------------------------------------
// timestamp
// ---------------------------------------------------------------------

// date time
timestamp: EVERYTHINGELSE ws.opt EVERYTHINGELSE ws.opt {
  MAKENODE();
}

includes: {
  MAKENODE();
}

includes: includes KEYWORD_FOLDERS ws.opt argumentList newline KEYWORD_INCLUDES ws.opt argumentList
    newline {
  MAKENODE();
}

percent: '%' {
  depTree->currentFolder = depTree->depReaderCurrentFolder;
  MAKENODE();
}

// ---------------------------------------------------------------------
// Arguments
// ---------------------------------------------------------------------

argument: argumentPiece {
  MAKENODE();
}

argument: argument argumentPiece {
  MAKENODE();
}

argument: argument '%' {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Argument pieces
// ---------------------------------------------------------------------

argumentPiece: EVERYTHINGELSE {
  MAKENODE();
}

argumentPiece: IDENTIFIER {
  MAKENODE();
}

argumentPiece: KEYWORD_IN {
  MAKENODE();
}

argumentPiece: STRING {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Argument lists
// ---------------------------------------------------------------------

argumentList: {
  MAKENODE();
}

argumentList: argumentList argumentPiece ws.opt {
  MAKENODE();
}

argumentList: argumentList '%' ws.opt {
  MAKENODE();
}

argumentList: argumentList '=' ws.opt {
  MAKENODE();
}

argumentList: argumentList KEYWORD_INCLUDE ws.opt {
  MAKENODE();
}

argumentList: argumentList KEYWORD_FINDINCLUDES ws.opt {
  MAKENODE();
}

argumentList: argumentList '!' ws.opt {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Zero or more whitespace lines. Only used at start of file
// ---------------------------------------------------------------------

newlinews: ws.opt {
  MAKENODE();
}

newlinews: newlinews NEWLINE ws.opt {
  MAKENODE();
}

// ---------------------------------------------------------------------
// newline.opt
// ---------------------------------------------------------------------

newline.opt: newline {
  MAKENODE();
}

newline.opt: {
  MAKENODE();
}

// ---------------------------------------------------------------------
// newline followed by more newlines or other whitespaces
// ---------------------------------------------------------------------

newline: NEWLINE ws.opt {
  MAKENODE();
}

newline: newline NEWLINE ws.opt {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Optional whitespace
// ---------------------------------------------------------------------

ws.opt: {
  MAKENODE();
}

ws.opt: ws {
  MAKENODE();
}

// ---------------------------------------------------------------------
// True whitespace
// ---------------------------------------------------------------------

ws: wsbit {
  MAKENODE();
}

ws: ws wsbit {
  MAKENODE();
}

// ---------------------------------------------------------------------
// Whitespace bits including macros, directives, cmdsubs
// ---------------------------------------------------------------------

wsbit: WS {
  MAKENODE();
}

wsbit: COMMENT {
  MAKENODE();
}

wsbit: macroCall {
  MAKENODE();
}

macroCall: '$' '{' IDENTIFIER '}' {
  if (depTree->activeCode) {
    depTree->callMacro($3);
    $1->hidden = HIDDEN_MACRO_CALL;
    $2->hidden = HIDDEN_MACRO_CALL;
    $3->hidden = HIDDEN_MACRO_CALL;
    $4->hidden = HIDDEN_MACRO_CALL;
  }
  MAKENODE();
}

macroCall: '$' IDENTIFIER {
  if (depTree->activeCode) {
    depTree->callMacro($2);
    $1->hidden = HIDDEN_MACRO_CALL;
    $2->hidden = HIDDEN_MACRO_CALL;
  }
  MAKENODE();
}

macroCall: '`' command '`' {
  if (depTree->activeCode) {
    depTree->substituteCommand($2);
    $1->hidden = HIDDEN_MACRO_CALL;
    $2->hidden = HIDDEN_MACRO_CALL;
    $3->hidden = HIDDEN_MACRO_CALL;
  }
  MAKENODE();
}

// ---------------------------------------------------------------------
// command substitutions
// ---------------------------------------------------------------------

command: {
  MAKENODE();
}

command: command IDENTIFIER {
  MAKENODE();
}

command: command WS {
  MAKENODE();
}

command: command EVERYTHINGELSE {
  MAKENODE();
}

// ---------------------------------------------------------------------
%% // Epilogue (wizard code)
// ---------------------------------------------------------------------

int depparseGetSymbolNumber(int token) {
  return YYTRANSLATE(token);
}

const char *depparseGetSymbolName(int symbol) {
  if (symbol < YYNTOKENS + YYNNTS)
    return yytname[symbol];
  return "[Invalid symbol number]";
}

// Epilogue (user code)

