
// matches.h
// Copyright 2015 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef MATCHES_H
#define MATCHES_H

#include <string>
#include <vector>

#include <regex>

// Note: <regex> is unimplemented/experimental as of g++ 4.8.5 (Amazon Linux AMI 1)
// It was implemented and released in g++ 4.9.0
//
// https://stackoverflow.com/questions/12530406/is-gcc-4-8-or-earlier-buggy-about-regular-expressions

struct Pattern {
  Pattern(const char *pattern,
    std::regex_constants::syntax_option_type patternType = std::regex_constants::ECMAScript);
  void setup(const char *pattern,
    std::regex_constants::syntax_option_type patternType = std::regex_constants::ECMAScript);
  std::string s;
  std::regex re;
  int matches(const std::string &s, int *posPtr = 0, int *lenPtr = 0) const;
  int within(const std::string &s, int *posPtr = 0, int *lenPtr = 0) const;
};

struct StartPattern: Pattern {
  StartPattern(const char *pattern, std::regex_constants::syntax_option_type patternType, int flags);
  std::string s; // The full string
  int useRegex; // Boolean: There are wildcards etc
  int howFar;
  int flags;
  int patternStartsWith(const char *s, const char *start, int startlen, int *lenPtr) const;
  int fastMatches(const std::string &s, int *posPtr = 0, int *lenPtr = 0) const;
};

// Other bits+pieces

#define STARTSWITH_NONE    0
#define STARTSWITH_FIXED   1
#define STARTSWITH_MATCHES 2

int startsWith(/*int flags,*/ const char *s, const char *start);
int startsWith(/*int flags,*/ const char *s, const char *start, int startlen, int *lenPtr);

int endsWith(/*int flags,*/ const char *s, const char *end);
int endsWith(/*int flags,*/ const char *s, const char *end, int endlen);

// Lexer (Lexical Analyzer/Lexical Scanner)

struct ScanResult {
  int token;
  const char *str;
  int len;
};

int operator == (const ScanResult &a, const ScanResult &b);

#define LEXER_DISCARD 1

struct Token {
  Token(const char *regexp, const char *code, int flags);
  Pattern pattern;
  const char *code;
  int flags;
};

struct Lexer {
  int addToken(const char *regexp, const char *code, int flags);
  const char *scan(const char *s, ScanResult *result);
  std::vector<Token> exprVector;
  void scanAll(const char *input, std::vector<ScanResult> &scanResult, std::string *keyString);
};

#endif

