
// quote.h
// Copyright 2015 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef QUOTEH
#define QUOTEH

//#include <string>
#include "stringify.h"

std::string hexPair(unsigned char x);

std::string partlyQuote(const std::string &s);
std::string partlyQuote(char s);
std::string partlyQuote(const char *s);
std::string partlyQuote(const char *s, int len);
std::string partlyQuote(const std::wstring &s);
std::string partlyQuote(wchar_t s);
std::string partlyQuote(const wchar_t *s);
std::string partlyQuote(const wchar_t *s, int len);

std::string quote(const std::string &s);
std::string quote(char s);
std::string quote(const char *s);
std::string quote(const char *s, int len);
std::string quote(const std::wstring &s);
std::string quote(wchar_t s);
std::string quote(const wchar_t *s);
std::string quote(const wchar_t *s, int len);

std::string strings(const std::string &s);
std::string strings(const char *s);
std::string strings(const char *s, int len);
std::string strings(const std::wstring &s);
std::string strings(const wchar_t *s);
std::string strings(const wchar_t *s, int len);

std::string hexquote(const std::string &s);
std::string hexquote(char s);
std::string hexquote(const char *s);
std::string hexquote(const char *s, int len);
std::string hexquote(const std::wstring &s);
std::string hexquote(wchar_t s);
std::string hexquote(const wchar_t *s);
std::string hexquote(const wchar_t *s, int len);

std::string quoteAsNec(String s);

#endif
