
// stream_vector.h
// Copyright 2022 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef STREAM_VECTOR_H
#define STREAM_VECTOR_H

#include <iostream>
#include <vector>

template<typename T> std::ostream &operator << (std::ostream &os, const std::vector<T> &v) {
  os << '[';
  for (typename std::vector<T>::const_iterator i = v.begin(); i != v.end(); i++) {
    if (i != v.begin())
      os << ',';
    os << *i;
  }
  os << ']';
  return os;
}

template<typename T> std::ostream &operator << (std::ostream &os, const std::vector<T *> &v) {
  os << '[';
  for (typename std::vector<T *>::const_iterator i = v.begin(); i != v.end(); i++) {
    if (i != v.begin())
      os << ',';
    os << **i;
  }
  os << ']';
  return os;
}

#endif

